IF  EXISTS( SELECT  * FROM  SYS.OBJECTS 
	WHERE  NAME LIKE 'P_PDV_VD_IT_COMIS_RECALC_ANTIGO' AND TYPE = 'P' )
BEGIN
	DROP PROCEDURE P_PDV_VD_IT_COMIS_RECALC_ANTIGO
END

GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
CREATE PROCEDURE [dbo].[P_PDV_VD_IT_COMIS_RECALC_ANTIGO] (  @Cd_emp     Int = 1,
												 @Cd_filial INT, 
												 @DtIni     Date,  
												 @DtFim     Date)
AS
/************************************************************************************************************/
/*	ATUALIZANDO VALORES DE FABRICANTE														   */
/************************************************************************************************************/

    UPDATE it
    SET
	   it.VLR_COMISSAO_FABRIC = P.VLR_COMISSAO_FABRIC
    FROM
	   PDV_VD_IT it
	   INNER JOIN EST_PROD P ON
	   it.CD_EMP = P.CD_EMP AND 
	   it.CD_PROD = P.CD_PROD
    Where 
	   it.CD_EMP =  @Cd_emp
	   AND it.DT_VD BETWEEN  @DtIni AND  @DtFim
	   AND it.CD_FILIAL = @Cd_Filial
	  and p.VLR_COMISSAO_FABRIC > 0 ;


    --Fabricante por filial..
    UPDATE it
    SET
	   it.VLR_COMISSAO_FABRIC = P.VLR_COMISSAO_FABRIC
    FROM
	   PDV_VD_IT it
	   INNER JOIN EST_PROD_CPL P ON
	   it.CD_EMP	 = P.CD_EMP AND 
	   it.CD_FILIAL = P.CD_FILIAL AND 
	   it.CD_PROD	 = P.CD_PROD
    Where 
	   it.CD_EMP =  @Cd_emp
	   AND it.DT_VD BETWEEN  @DtIni AND  @DtFim
	   AND it.CD_FILIAL = @Cd_Filial
	   and p.VLR_COMISSAO_FABRIC > 0 ;


/************************************************************************************************************/
/*	CALCULO COMISSAO HIERARQUIA    														   */
/************************************************************************************************************/

--COMISSO POR CARGO E LINHA
UPDATE  it
SET 
    it.PERC_COMIS  = C.PERC_COMIS  -- Linha	
FROM
    PDV_VD_IT it          
    INNER JOIN EST_PROD_EST_ARV_MERCADOLOGICA  A ON
    it.CD_EMP  = A.CD_EMP AND 
    it.CD_PROD = A.CD_PROD
         
    INNER JOIN FP_FUNC ON
    it.CD_EMP = FP_FUNC.CD_EMP AND 
    it.CD_VEND = FP_FUNC.CD_FUN
         
    INNER JOIN FP_CARGO_EST_ARV_MERC_LINHA_COMIS  C ON
    A.CD_EMP		   = C.CD_EMP AND 
    A.CD_ARV_MERC_LINHA = C.CD_ARV_MERC_LINHA 
    
    AND  FP_FUNC.CD_CARGO = C.CD_CARGO
Where 
    it.CD_EMP = @Cd_emp
    AND it.DT_VD BETWEEN @DtIni AND @DtFIM
    AND it.CD_FILIAL = @Cd_filial
    AND C.PERC_COMIS > 0;
--------------------------------------------------------------------------------------------------
--COMISSO POR PRODUTO
UPDATE  it
SET 
    it.PERC_COMIS  = P.PERC_COMIS  	
FROM
    PDV_VD_IT it          
    INNER JOIN EST_PROD P ON
    it.CD_EMP  = P.CD_EMP AND 
    it.CD_PROD = P.CD_PROD
Where 
    it.CD_EMP = @Cd_emp
    AND it.DT_VD BETWEEN @DtIni AND @DtFIM
    AND it.CD_FILIAL = @Cd_filial
    AND P.PERC_COMIS > 0;
--------------------------------------------------------------------------------------------------
--COMISSO POR PRODUTO FILIAL
UPDATE  it
SET 
    it.PERC_COMIS  = P.PERC_COMIS   
FROM
    PDV_VD_IT it          
    INNER JOIN EST_PROD_CPL P ON
    it.CD_EMP  = P.CD_EMP AND 
    it.CD_FILIAL  = P.CD_FILIAL AND 
    it.CD_PROD = P.CD_PROD
Where 
    it.CD_EMP = @Cd_emp
    AND it.DT_VD BETWEEN @DtIni AND @DtFIM
    AND it.CD_FILIAL = @Cd_filial
    AND P.PERC_COMIS > 0;

--------------------------------------------------------------------------------------------------
--  ISNULL(V_EST_GRP_COMIS_DESC.PERC_COMIS_DESC,0)

-- ISNULL(V_EST_GRP_COMIS_META.PERC_COMIS,0)

/*****************************************************************
--Implementar regressoes

If Opt_RegressaoDesc.value = True Then

    INNER JOIN V_EST_GRP_COMIS_DESC ON"
    it.CD_EMP = V_EST_GRP_COMIS_DESC.CD_EMP"
    AND it.CD_FILIAL = V_EST_GRP_COMIS_DESC.CD_FILIAL"
    AND it.CD_VEND = V_EST_GRP_COMIS_DESC.CD_FUN"
    AND it.CD_PROD = V_EST_GRP_COMIS_DESC.CD_PROD"
             
    AND ROUND(V_PDV_VD_IT.DESC_TOTAL_IT,2) BETWEEN V_EST_GRP_COMIS_DESC.DESC_INI AND V_EST_GRP_COMIS_DESC.DESC_FIM"
             
    AND it.QT_IT BETWEEN V_EST_GRP_COMIS_DESC.QTDE_INI AND V_EST_GRP_COMIS_DESC.QTDE_FINAL"
             
    INNER JOIN EST_GRP_COMIS_DESC_REGRESSAO ON"
    it.TIPO_DESCONTO = EST_GRP_COMIS_DESC_REGRESSAO.TP_DESCONTO"
    AND EST_GRP_COMIS_DESC_REGRESSAO.VINCULADO = 1"
             
ElseIf Opt_RegressaoMeta.value = True Then
    INNER JOIN (SELECT"
    CD_EMP,"
    CD_FILIAL,"
    CD_VEND,"
    NM_FUN,"
    SUM(ISNULL(VLR_LIQ_VD,0)) AS VLR_LIQ_VD,"
    SUM(ISNULL(META_VD,0)) AS META_VD,"
    (SUM(ISNULL(VLR_LIQ_VD,0)) * 100) / SUM(CASE WHEN ISNULL(META_VD,1) = 0 THEN 1 ELSE ISNULL(META_VD,1) END) AS META_REALIZADO,"
    MONTH(DATA_REF) AS MES_REF,"
    YEAR(DATA_REF) AS ANO_REF"
    FROM"
    V_EST_META_VEND_DIARIO_REALIZADO"
    GROUP BY"
    CD_EMP,"
    CD_FILIAL,"
    CD_VEND,"
    NM_FUN,"
    MONTH(DATA_REF),"
    YEAR(DATA_REF))"
    TBL ON"
    it.CD_EMP = TBL.CD_EMP"
    AND it.CD_FILIAL = TBL.CD_FILIAL"
    AND it.CD_VEND = TBL.CD_VEND"
    AND YEAR(it.DT_VD) = TBL.ANO_REF"
    AND MONTH(it.DT_VD) = TBL.MES_REF"
         
    LEFT JOIN V_EST_GRP_COMIS_META ON"
    TBL.CD_EMP = V_EST_GRP_COMIS_META.CD_EMP"
    AND TBL.CD_FILIAL = V_EST_GRP_COMIS_META.CD_FILIAL"
    AND TBL.CD_VEND   = V_EST_GRP_COMIS_META.CD_FUN"
    AND TBL.META_REALIZADO BETWEEN V_EST_GRP_COMIS_META.META_INI AND V_EST_GRP_COMIS_META.META_FIM"
    AND it.CD_PROD = V_EST_GRP_COMIS_META.CD_PROD"
    AND it.QT_IT BETWEEN V_EST_GRP_COMIS_META.QTDE_INI AND V_EST_GRP_COMIS_META.QTDE_FINAL"
         
End If
         
*/